﻿//////////////////////////////////////////////
// DofProgramsTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Program ;
	class System ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "DofComplexEffectInfo.h"

// Standards
#include <unordered_map>

/// Internals --------------------------------

namespace nkAstraeus
{
	struct DofProgramsIdGenerator
	{
		static unsigned long long generate (const DofComplexEffectInfo& info) ;
	} ;

	struct DofProgramsNameGenerator
	{
		constexpr static const char* name = "NILKINS_DOF_PROGRAM_" ;
	} ;

	struct DofProgramsEntry
	{
		nkMemory::UniquePtr<nkGraphics::Program> _programDownSample ;
		nkMemory::UniquePtr<nkGraphics::Program> _programBlend ;
		unsigned int _count = 0 ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class DofProgramsTracker final
	{
		public :

			// Constructor, destructor
			DofProgramsTracker (nkGraphics::System* graphicsSystem) noexcept ;
			~DofProgramsTracker () ;

			// Memory management
			std::pair<nkGraphics::Program*, nkGraphics::Program*> getPrograms (const DofComplexEffectInfo& info) ;
			void releasePrograms (const DofComplexEffectInfo& info) ;

		private :

			// Functions
			// Constructors
			DofProgramsTracker (const DofProgramsTracker&) = delete ;
			DofProgramsTracker (DofProgramsTracker&&) = delete ;

			// Operators
			DofProgramsTracker& operator= (const DofProgramsTracker&) = delete ;
			DofProgramsTracker& operator= (DofProgramsTracker&&) = delete ;

		private :

			// Attributes
			nkGraphics::System* _graphicsSystem ;

			// Memory of programs
			std::unordered_map<unsigned long long, DofProgramsEntry> _memory ;
	} ;
}